package nu.mine.flashnet.sound.synthesis
{
	import nu.mine.flashnet.sound.core.PCMSoundFormat;
	import nu.mine.flashnet.sound.synthesis.tones.*;
	
	public class ToneGenerator
	{
		protected var frequency:Number;
		protected var phase:Number;
		//private var type:String;
		protected var soundFormat:PCMSoundFormat;
		public static const SINE:String="sine";
		public static const SQUARE:String="square";
		public static const TRIANGULAR:String="triangular";
		public static const SAW:String="saw";
		
		private var sin:Number;
		private var cos:Number;
		
		public function ToneGenerator(soundFormat:PCMSoundFormat,frequency:Number=440.0)
		{
			this.sin=0.0;
			this.cos=1.0;
			this.soundFormat=soundFormat;
			this.frequency = frequency;
			//this.type=type;
			this.phase=0.0;
		}
		public static function getGenerator(soundFormat:PCMSoundFormat,type:String=SINE,frequency:Number=440.0):ToneGenerator
		
		{
			switch(type)
			{
				case SINE:
					return new SineToneGenerator(soundFormat,frequency);
					break;
				case SQUARE:
					return new SquareToneGenerator(soundFormat,frequency);
					break;
				case TRIANGULAR:
					return new TriangularToneGenerator(soundFormat,frequency);
					break;
				case SAW:
					return new SawToneGenerator(soundFormat,frequency);
					break;
				default:
					throw(new Error("tone type "+type+" is unsupported"))
			}

			
		}
		protected function getNextSampleValue():Number
		{
			throw(new Error("this method is considered abstract. Use ToneGenerator.getGenerator to obtain subclass instance"));
		}
		public function getNextSample():Number
		{
			var val:Number=getNextSampleValue();

			phase+=(frequency*(2*Math.PI/soundFormat.sampleRate)); //this should give us a tone of 440hZ. Concert A.
				
			if(phase>(2*Math.PI))
			{
				phase-=(2*Math.PI); //prevent phase from overflowing.
			}
			return val;

		}
		
		public function setPitch(frequency:Number):void
		{
			this.frequency = frequency;
		}
		
	}

}

/*
 double  sin = 0.0,
                                cos = 1.0,
                                frq = 2.0 * M_PI / length;

                        for ( 1 .. length-1 ) {

                                cos -= sin * frq;
                                sin += cos * frq;

                        }*/