package {
	
	import away3d.cameras.HoverCamera3D;
	import away3d.core.material.BitmapMaterial;
	import away3d.core.material.MaterialLibrary;
	import away3d.core.material.WireColorMaterial;
	import away3d.core.material.WireframeMaterial;
	import away3d.core.proto.Object3D;
	import away3d.core.proto.Scene3D;
	import away3d.core.render.AnotherRivalFilter;
	import away3d.core.render.BasicRenderer;
	import away3d.core.render.QuadrantRenderer;
	import away3d.loaders.Collada;
	import away3d.objects.Cube;
	
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	
	import net.saqoosha.garapon.StageRef;

	public class FxUGscene extends Sprite {
		
		[Embed(source="assets/fxug.dae",mimeType="application/octet-stream")]
		private var fxugobjClass:Class;
		
		[Embed(source="assets/tex1.png")]
	    private static var texImage1:Class;

		[Embed(source="assets/tex2.png")]
	    private static var texImage2:Class;

		private var _scene:Scene3D;
		private var _obj:Object3D;
		private var _camera:HoverCamera3D;
		private var _targetdistance:Number;
		private var _renderer:QuadrantRenderer;
		
		private var _keyEnabled:Boolean;
		private var _keyState:Object;
		
		public function FxUGscene() {
			this._keyState = new Object();
			//StageRef.getInstance().addEventListener(KeyboardEvent.KEY_DOWN, this.handleKeyDown);
			//StageRef.getInstance().addEventListener(KeyboardEvent.KEY_UP, this.handleKeyUp);
			
			// シーン作る。
			this._scene = new Scene3D();
			this.addChild(this._scene.container);

			// マテリアル作る。
			var matlib:MaterialLibrary = new MaterialLibrary()
			//matlib.add(new WireColorMaterial(0xffffff, 0.5, 0xff0000, 0.1, 1), 'fxug');
			matlib.add(new BitmapMaterial(Bitmap(new texImage1()).bitmapData), 'fxug');
			matlib.add(new BitmapMaterial(Bitmap(new texImage2()).bitmapData), 'fxug2');

			// オブジェクト作る。
			this._obj = this._scene.addChild(new Collada(new XML(new fxugobjClass()), matlib, 3));
			//this._obj = this._scene.addChild(new Cube());
			this._scene.addChild(this._obj);

			// そしてカメラを作ります。
			this._camera = new HoverCamera3D(this._obj, 1, 200);
			this._camera.distance = this._targetdistance = 300;
			this._camera.panangle = this._camera.targetpanangle = 0;
			this._camera.tiltangle = this._camera.targettiltangle = 0;
			this._camera.mintiltangle = -90;
			this._camera.hover();

			// レンダラーを作りましょう。
			this._renderer = new QuadrantRenderer(new AnotherRivalFilter());
			//this._renderer = new BasicRenderer();
			
			// いつもどおり ENTER_FRAME イベントをリッスン。
			this.addEventListener(Event.ENTER_FRAME, this.handleEnterFrame);
		}
		

		/**
		 * レンダリングレンダリングー。
		 */		
		private function handleEnterFrame(e:Event):void {
			if (this._keyEnabled) {
				this.debugMove();
			}
			this._camera.hover();
			this._camera.distance += (this._targetdistance - this._camera.distance) / (this._camera.steps + 1);
			this._scene.render(this._camera, this._renderer);
		}
		
		public function set panAngle(n:Number):void {
			this._camera.targetpanangle = n;
		}
		public function get panAngle():Number {
			return this._camera.targetpanangle;
		}
		public function set tiltAngle(n:Number):void {
			this._camera.targettiltangle = n;
		}
		public function get tiltAngle():Number {
			return this._camera.targettiltangle;
		}
		public function set distance(n:Number):void {
			//this._camera.distance = n;
			this._targetdistance = n;
		}
		public function get distance():Number {
			//return this._camera.distance;
			return this._targetdistance;
		}
		
		
		/**
		 * Tweener の Special Property 用の getter / setter
		 */		
		private function getObject3DScale(p_obj:Object):Number {
			return Object3D(p_obj).extra.scale;
		}
		private function setObject3DScale(p_obj:Object, p_value:Number):void {
			Object3D(p_obj).scale = Object3D(p_obj).extra.scale = p_value;
		}


		/**
		 * このへんはデバグ用カメラ動かし用。
		 */		
		private function handleKeyDown(e:KeyboardEvent):void {
			trace('keydown',e.keyCode);
			this._keyState[e.keyCode] = true;
			
			switch (e.keyCode) {
				case 90:  // Z
					trace(this._camera.distance, this._camera.panangle, this._camera.tiltangle);
					break;
				case 32:  // (space)
					if (!this._keyEnabled) {  // このへんの実装は美しくない。。とりあえず動けばヨシ。
					}
					break;
			}
		}
		private function handleKeyUp(e:KeyboardEvent):void {
			trace('keyup',e.keyCode);
			delete this._keyState[e.keyCode];
		}
		private function debugMove():void {
			for (var charCode:String in this._keyState) {
				switch (Number(charCode)) {
					case 37: //left
						break;
					case 39: //right;
						break;
					case 38: //up
						this._camera.distance += 5;
						break;
					case 40: //down
						this._camera.distance -= 5;
						break;
					
					case 87: // W
						//this._cameraTarget.moveUp(3);
						this._camera.targettiltangle += 3;
						break;
					case 83: // S
						//this._cameraTarget.moveDown(3);
						this._camera.targettiltangle -= 3;
						break;
					case 65: // A
						//this._cameraTarget.moveLeft(3);
						this._camera.targetpanangle += 3;
						break;
					case 68: // D
						//this._cameraTarget.moveRight(3);
						this._camera.targetpanangle -= 3;
						break;
				}
			}
		}
	}
}