/*
 * Decompiled with CFR 0.152.
 */
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class Serial
implements SerialPortEventListener {
    private SerialProxy parent;
    public SerialPort port;
    private final int rate = 38400;
    private final int parity = 0;
    private final int databits = 8;
    private final int stopbits = 1;
    public InputStream input;
    public OutputStream output;
    byte[] buffer = new byte[64];
    int bufferIndex;
    int bufferLast;
    int bufferSize = 64;

    public Serial(SerialProxy sp, String iname) {
        this.parent = sp;
        this.parent.printMsg("starting GAINER...");
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || !portId.getName().equals(iname)) continue;
                this.port = (SerialPort)portId.open("serial gainer", 2000);
                this.input = this.port.getInputStream();
                this.output = this.port.getOutputStream();
                this.port.setSerialPortParams(38400, 8, 1, 0);
                this.port.addEventListener((SerialPortEventListener)this);
                this.port.notifyOnDataAvailable(true);
                this.parent.printMsg("GAINER started on port " + iname);
            }
            if (this.port == null) {
                this.printMsg("specified port was not found...");
            }
        }
        catch (Exception e) {
            this.printMsg("connection error inside Serial. closing serialport...");
            e.printStackTrace();
            this.port = null;
            this.input = null;
            this.output = null;
        }
    }

    public static String autoPortName() {
        String dname = null;
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1) continue;
                String pname = portId.getName();
                if (pname.startsWith("/dev/cu.usbserial-")) {
                    dname = pname;
                    continue;
                }
                if (!pname.startsWith("COM")) continue;
                dname = "COM3";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dname;
    }

    public void printMsg(String msg) {
        this.parent.printMsg(msg);
    }

    public void dispose() {
        this.port.removeEventListener();
        this.printMsg("dispose Gainer ..");
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.port = null;
    }

    /*
     * Exception decompiling
     */
    public synchronized void serialEvent(SerialPortEvent serialEvent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    public String readStringUntil(int interesting) {
        byte[] b = this.readBytesUntil(interesting);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytesUntil(int interesting) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int found = -1;
            int k = this.bufferIndex;
            while (k < this.bufferLast) {
                if (this.buffer[k] == what) {
                    found = k;
                    break;
                }
                ++k;
            }
            if (found == -1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            int length = found - this.bufferIndex + 1;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return outgoing;
        }
    }

    public void write(String what) {
        try {
            this.output.write(what.getBytes());
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

