/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;

public class Client
extends Thread {
    private Server server;
    private Socket socket;
    protected BufferedReader in;
    protected PrintWriter out;
    private String ip;
    private boolean runFlag = true;

    public Client(Server server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.ip = socket.getInetAddress().getHostAddress();
        try {
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "SJIS"));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "SJIS"), true);
        }
        catch (IOException ioe) {
            server.printMsg("initilization error on Client: " + this.ip + ". disconnected.");
            ioe.printStackTrace();
            this.stopClient();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                char[] c = new char[1];
                block5: while (this.in.read(c, 0, 1) != -1 && this.runFlag) {
                    StringBuffer sb = new StringBuffer(4096);
                    while (true) {
                        if (c[0] == '\u0000') {
                            this.server.onReceiveMsg(sb.toString());
                            continue block5;
                        }
                        sb.append(c[0]);
                        this.in.read(c, 0, 1);
                    }
                }
            }
            catch (IOException ioe) {
                this.server.printMsg("read error on Client: " + this.ip + ". disconnected.");
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.stopClient();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.stopClient();
            return;
        }
    }

    public final String getIP() {
        return this.ip;
    }

    public void sendToClient(String msg) {
        this.out.print(String.valueOf(msg) + "\u0000");
        if (this.out.checkError()) {
            this.server.printMsg("write error on Client: " + this.ip + ". disconnected.");
            this.stopClient();
        }
    }

    private void stopClient() {
        this.server.deleteClient(this);
        try {
            this.in.close();
            this.out.close();
            this.socket.close();
        }
        catch (IOException ioe) {
            this.server.printMsg("connection error on Client: " + this.ip);
            ioe.printStackTrace();
        }
    }

    public void dispose() {
        this.runFlag = false;
    }
}

