/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class SerialProxy
extends Frame {
    private Server server;
    private Serial gainer;
    private TextArea log;
    private boolean logEnable = false;

    public SerialProxy() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (((SerialProxy)SerialProxy.this).gainer.port != null) {
                    SerialProxy.this.gainer.write("E*");
                }
                System.exit(0);
            }
        });
        this.setTitle("GAINER serial proxy");
        this.setSize(300, 200);
        this.show();
        this.setLayout(null);
        this.setResizable(false);
        this.log = new TextArea("GAINER serial proxy\n@author PDP Project\n@version 1.0\n\n", 5, 10, 1);
        Insets insets = this.getInsets();
        this.log.setBounds(insets.left, insets.top, 300 - (insets.left + insets.right), 200 - (insets.top + insets.bottom));
        this.log.setEditable(false);
        this.add(this.log);
        String[] setting = this.loadStrings("setting.txt");
        if (setting[0] == null) {
            setting[0] = "2000";
            this.printMsg("undefined server port. use default setting: " + setting[0]);
        }
        if (setting[1] == null) {
            setting[1] = Serial.autoPortName();
            this.printMsg("undefined serial port. use default setting: " + setting[1]);
        }
        this.server = new Server(this, Integer.parseInt(setting[0]));
        this.server.start();
        this.gainer = new Serial(this, setting[1]);
    }

    public void sendToGainer(String msg) {
        if (msg.startsWith("startLog")) {
            this.logEnable = true;
        } else if (msg.startsWith("stopLog")) {
            this.logEnable = false;
        } else if (msg.startsWith("clearLog")) {
            this.log.setText("");
        } else {
            this.gainer.write(msg);
            if (this.logEnable) {
                this.printMsg("from client: " + msg);
            }
        }
    }

    public void sendToFlash(String msg) {
        this.server.sendToAll(msg);
        if (this.logEnable) {
            this.printMsg("from GAINER: " + msg);
        }
    }

    public void printMsg(String msg) {
        this.log.append(String.valueOf(msg) + "\n");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] loadStrings(String filename) {
        block15: {
            setting = new String[2];
            fileReader = null;
            bufferedReader = null;
            try {
                try {
                    fileReader = new FileReader(filename);
                    bufferedReader = new BufferedReader(fileReader);
                    i = 0;
                    while (i < 2 && (line = bufferedReader.readLine()) != null) {
                        setting[i] = line;
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable var8_8) {
                var7_9 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fileReader == null) throw var8_8;
                    fileReader.close();
                    throw var8_8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var8_8;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 88->101)] { 
lbl36:
            // 1 sources

            if (bufferedReader != null) {
                bufferedReader.close();
            }
            break block15;
lbl39:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return setting;
        }
        if (fileReader == null) return setting;
        fileReader.close();
        return setting;
    }

    public static void main(String[] args) {
        new SerialProxy();
    }
}

