/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class Server
extends Thread {
    private ServerSocket srvsocket;
    private Vector clist;
    private int port;
    private SerialProxy parent;

    public Server(SerialProxy parent, int port) {
        this.parent = parent;
        this.clist = new Vector();
        this.port = port;
    }

    public void sendToAll(String msg) {
        if (this.clist != null) {
            Enumeration e = this.clist.elements();
            while (e.hasMoreElements()) {
                Client c = (Client)e.nextElement();
                c.sendToClient(msg);
            }
        }
    }

    public synchronized int getClientsCount() {
        return this.clist.size();
    }

    public void printMsg(String msg) {
        this.parent.printMsg(msg);
    }

    public void run() {
        this.printMsg("starting server...");
        try {
            this.srvsocket = new ServerSocket(this.port);
            this.printMsg("server started on port " + this.port);
            while (true) {
                Socket sock = this.srvsocket.accept();
                Client c = new Client(this, sock);
                this.clist.add(c);
                this.printMsg(String.valueOf(c.getIP()) + " connected to the server.");
                c.start();
            }
        }
        catch (IOException ioe) {
            this.printMsg("connection error inside Server. closing serversocket...");
            ioe.printStackTrace();
            this.stopServer();
            return;
        }
    }

    private void stopServer() {
        try {
            this.srvsocket.close();
            this.printMsg("serversocket closed");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void deleteClient(Client c) {
        this.printMsg(String.valueOf(c.getIP()) + " disconnected.");
        this.clist.remove(c);
    }

    public void onReceiveMsg(String msg) {
        this.parent.sendToGainer(msg);
    }

    public void dispose() {
        if (this.clist != null) {
            Enumeration e = this.clist.elements();
            while (e.hasMoreElements()) {
                Client c = (Client)e.nextElement();
                c.dispose();
            }
        }
    }
}

