package net.saqoosha.garapon {
	
	import away3d.core.draw.Vertex2D;
	import away3d.core.material.BitmapMaterial;
	import away3d.core.material.MaterialLibrary;
	import away3d.core.material.WireColorMaterial;
	import away3d.loaders.Collada;
	
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IEventDispatcher;
	import mx.core.SoundAsset;

	/**
	 * ころりん。玉クラス。
	 */	
	public class Ball extends Collada implements IEventDispatcher {

		// マテリアルの名前ですな。
		private static const MATERIAL_NAME:String = 'ball';
		
		// 地面にぶつかったときの音。
		[Embed(source='../../../assets/ball.mp3')]
		private static var ballSoundClass:Class;
		private static var ballSound:SoundAsset;
		
		/**
		 * サウンドオブジェクトつくっとこう。
		 */		
		public static function initSound():void {
			if (ballSound is SoundAsset)
				return;
			ballSound = SoundAsset(new ballSoundClass());
		}
		
		/**
		 * 鳴らしますよ。
		 */		
		public static function playSound():void {
			ballSound.play(0);
		}
		

		private var _eventDispatcher:EventDispatcher
		private var _speedX:Number;
		private var _speedY:Number;
		
		
		/**
		 * 玉つくる。
		 * @param xml		玉オブジェクトの Collada フォーマットの XML。
		 * @param texture	テクスチャの BitmapData。
		 * @param scale		大きさ。
		 */		
		public function Ball(xml:XML, texture:BitmapData=null, scale:Number=1) {
			var matlib:MaterialLibrary = new MaterialLibrary();
			if (texture is BitmapData) {
				var b:BitmapMaterial = new BitmapMaterial(texture);
				b.smooth = true;
				matlib.add(b, Ball.MATERIAL_NAME);
			} else {
				var mat:WireColorMaterial = new  WireColorMaterial(0xaa0000, 0x330000, 0.9, 0.8);
				matlib.add(mat, Ball.MATERIAL_NAME);
			}
			super(xml, matlib, scale);
			this._eventDispatcher = new EventDispatcher(this);
			Ball.initSound();
		}
		
		/**
		 * アニメーションを開始いたします。
		 * @param ix		最初の位置。
		 * @param iy		最初の位置。
		 * @param spx	最初のスピード。
		 * @param spy	最初のスピード。
		 */		
		public function start(ix:Number = 440, iy:Number = 0, spx:Number = 6, spy:Number =  0):void {
			this.x = ix;
			this.y = iy;
			this._speedX = spx;//6 + Math.random() * 2;
			this._speedY = spy;//0;
			
			StageRef.getInstance().addEventListener(Event.ENTER_FRAME, this.update);
		}
		
		/**
		 * アニメーションをどんどん進めましょう。
		 */		
		private function update(e:Event):void {
			this._speedX *= 0.99; // 空気抵抗とか
			this._speedY -= 1; // 重力とか
			this.x += this._speedX;
			this.y += this._speedY;
			this.rotationZ -= this._speedX * 3; // 適当に回しとく。なんとなくそれっぽく見える。
			this.rotationY += this._speedX; // Y 軸にも回しとくか。
			if (this.y < -460) { // 地面にぶつかった。
				this._speedX *= 0.98; // ちょっと減速。
				this._speedY *= -0.5; // スピード逆に。あんまし跳ねない。
				this.y = -460;
				if (Math.abs(this._speedY) > 1) {
					Ball.playSound();
				}
				if (Math.abs(this._speedY) + Math.abs(this._speedX) < 1) { // 止まったっぽい。
					StageRef.getInstance().removeEventListener(Event.ENTER_FRAME, this.update);
					this._eventDispatcher.dispatchEvent(new Event(Event.COMPLETE));
				}
			}
		}
		
		
		/**
		 * 以下、IEventDispatcher のメソッド。コピペ。
		 */		
		public function addEventListener( type: String, listener: Function, useCapture: Boolean = false, priority: int = 0, useWeakReference: Boolean = false ): void  {
			this._eventDispatcher.addEventListener( type, listener, useCapture, priority, useWeakReference );
		}
		public function dispatchEvent(event:Event):Boolean {
			return this._eventDispatcher.dispatchEvent(event);
		}
		public function hasEventListener( type: String ): Boolean {
			return this._eventDispatcher.hasEventListener( type );
		}
		public function removeEventListener( type: String, listener: Function, useCapture: Boolean = false ): void {
			this._eventDispatcher.removeEventListener( type, listener, useCapture );
		}
		public function willTrigger( type: String ): Boolean {
			return this._eventDispatcher.willTrigger( type );
		}
	}
}