package net.saqoosha.garapon {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.errors.IOError;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IEventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	

	/**
	 * 玉の設定を管理します。
	 */
	public class BallConfig implements IEventDispatcher {
		
		private var _eventDispatcher:EventDispatcher;
		private var _loader:URLLoader;
		private var _data:XML;
		private var _ballInfo:Array;
		private var _ballImages:Dictionary;
		private var _loaderCount:Number;
		
		/**
		 * ふつうにコンストラクタ。
		 */		
		public function BallConfig() {
			this._eventDispatcher = new  EventDispatcher(this);
			this._ballInfo = new Array();
		}
		
		/**
		 * 玉リストを読み込みます。
		 * @param configUrl	XMLファイルのURLね。デフォルトは balls.xml。
		 */		
		public function load(configUrl:String = 'balls.xml'):void {
			this._loader = new URLLoader();
			this._loader.addEventListener(Event.COMPLETE, this.handleConfigLoaded);
			this._loader.load(new URLRequest(configUrl));
		}
		
		/**
		 * XML読み込みおわりましたとさ。
		 */
		private function handleConfigLoaded(e:Event):void {
			this._loaderCount = 0;
			this._data = new XML(this._loader.data);
			for each(var b:XML in this._data.ball) {
				var binf:BallInfo = new BallInfo(b.@name);
				binf.addEventListener(Event.COMPLETE, this.handleImageLoaded);
				binf.load(b.@image);  // 今度はそれぞれのテクスチャを読み込みます。
				this._ballInfo.push(binf);
				this._loaderCount++;
			}
		}
		
		/**
		 * 玉テクスチャ1個読み込みました。
		 */
		private function handleImageLoaded(e:Event):void {
			if (--this._loaderCount == 0) { // 全部ロードした？
				this.dispatchEvent(new Event(Event.COMPLETE));
			}
		}
		
		/**
		 * とりあえずエラーの内容は出力しとく。
		 */
		private function handleImageLoadError(e:IOErrorEvent):void {
			trace(e);
		}
		
		/**
		 * さーー、抽選会場はここですよー。
		 * ランダムに玉を取り出します。
		 * @param reuse	でたたまを戻すか戻さないか。
		 * @return 		玉情報。
		 */
		public function getRandomBall(reuse:Boolean = true):BallInfo {
			if (this._ballInfo.length > 0) {
				var idx:Number = Math.floor(Math.random() * this._ballInfo.length);
				if (reuse) {
					return this._ballInfo[idx];
				} else {
					return this._ballInfo.splice(idx, 1)[0];
				}
			} else {
				return null;
			}
		}
		
		
		/**
		 * 以下、IEventDispatcher のメソッド。コピペ。
		 */		
		public function addEventListener( type: String, listener: Function, useCapture: Boolean = false, priority: int = 0, useWeakReference: Boolean = false ): void  {
			this._eventDispatcher.addEventListener( type, listener, useCapture, priority, useWeakReference );
		}
		public function dispatchEvent(event:Event):Boolean {
			return this._eventDispatcher.dispatchEvent(event);
		}
		public function hasEventListener( type: String ): Boolean {
			return this._eventDispatcher.hasEventListener( type );
		}
		public function removeEventListener( type: String, listener: Function, useCapture: Boolean = false ): void {
			this._eventDispatcher.removeEventListener( type, listener, useCapture );
		}
		public function willTrigger( type: String ): Boolean {
			return this._eventDispatcher.willTrigger( type );
		}

	}
}