package net.saqoosha.garapon {

	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IEventDispatcher;
	import flash.utils.Dictionary;
	
	import org.wiiflash.Wiimote;
	import org.wiiflash.events.ButtonEvent;
	import org.wiiflash.events.WiimoteEvent;
	
	[Event(name='recognized', type='net.saqoosha.garapon.GestureEvent')]
	
	/**
	 * Wiimoteの動きを読み取ってイベントを発生させます。
	 */
	public class GestureRecognizer implements IEventDispatcher {

		private var _eventDispatcher:EventDispatcher;
		private var _patterns:Dictionary
		private var _wiimote:Wiimote;
		private var _enabled:Boolean;

		private var _px:Number;
		private var _py:Number;
		private var _angle:Number;
		private var _history:Array;

		/**
		 * コンストラクタ。
		 * @param wiimote	どのWiimoteか教えてください。
		 */
		public function GestureRecognizer(wiimote:Wiimote) {
			this._eventDispatcher = new EventDispatcher(this);

			this._wiimote = wiimote;
			// Aボタンおしたときだけジェスチャー認識するです。
			this._wiimote.addEventListener(ButtonEvent.A_PRESS, this.handleWiimoteAPress);
			this._wiimote.addEventListener(ButtonEvent.A_RELEASE, this.handleWiimoteARelease);
			
			this._enabled  = true;

			this._px = 0;
			this._py = 0;
			this._angle = 0;
			this._history = new Array();

			this.registerPatterns();
		}

		/**
		 * ジェスチャーパターンを作ります。
		 * 今回は時計回りと反時計回りだけ。
		 * 今回はっていうかたぶんいまんとこそれぐらいしか認識できない。。
		 */
		private function registerPatterns():void {
			this._patterns = new Dictionary();
			
			var key:String;
			for (var i:Number = 0; i < 8; i++) {
				var j:Number;
				key = '';
				for (j  = 0; j < 3; j++) {
					key += String((i + j) % 8);
				}
				this._patterns[key] = 'cw';

				key = '';
				for (j = 2; j >= 0; j--) {
					key += String((i + j) % 8);
				}
				this._patterns[key] = 'ccw';
			}
		}
		
		/**
		 * Aボタンが押されました。
		 * 認識開始。
		 */
		private function handleWiimoteAPress(e:ButtonEvent):void {
			this._wiimote.addEventListener(WiimoteEvent.UPDATE, this.handleWiimoteUpdate);
		}
		
		/**
		 * Aボタンを離しました。
		 * 認識終了。
		 */		
		private function handleWiimoteARelease(e:ButtonEvent):void {
			this._wiimote.removeEventListener(WiimoteEvent.UPDATE, this.handleWiimoteUpdate);
		}
		
		/**
		 * Wiimoteの状況が変わったのでデータを読み取ります。
		 * アルゴリズムはー、、文字だけじゃ説明できないな。。。
		 */
		private function handleWiimoteUpdate(e:Event):void {
			var dx:Number = this._wiimote.sensorX;
			var dz:Number = this._wiimote.sensorZ - 1.0;
			if (Math.abs(dx) > 0.1 && Math.abs(dz) > 0.1) {
				var a:Number = Math.atan2(dz, dx);
				var aa:uint = Math.floor((a + (a < 0 ? Math.PI * 2 : 0)) / (Math.PI * 2) * 8);
				if (this._angle != aa) {
					this._angle = aa;
					this._history.push(aa);
					if (this._history.length > 8) {
						this._history.shift();
					}
					var key:String = this._history.slice(-3).join('');
					var rot:* = this._patterns[key];
					if (typeof(rot) == 'string') {
						this.dispatchEvent(new GestureEvent(GestureEvent.RECOGNIZED,  rot));
					}
				}
			}
		}
		
		/**
		 * 使える？
		 */
		public function get enabled():Boolean {
			return this._enabled;
		}
		
		/**
		 * このクラスの有効無効を切り替える。
		 * @param flg	説明はいらんだろ
		 */		
		public function set enabled(flg:Boolean):void {
			if (this._enabled != flg) {
				if (flg) {
					this._wiimote.addEventListener(ButtonEvent.A_PRESS, this.handleWiimoteAPress);
					this._wiimote.addEventListener(ButtonEvent.A_RELEASE, this.handleWiimoteARelease);
				} else {
					this._wiimote.removeEventListener(WiimoteEvent.UPDATE, this.handleWiimoteUpdate);
					this._wiimote.removeEventListener(ButtonEvent.A_PRESS, this.handleWiimoteAPress);
					this._wiimote.removeEventListener(ButtonEvent.A_RELEASE, this.handleWiimoteARelease);
				}
				this._enabled = flg;
			}
		}
		
		
		

		/**
		 * 以下、IEventDispatcher のメソッド。コピペ。
		 */		
		public function addEventListener( type: String, listener: Function, useCapture: Boolean = false, priority: int = 0, useWeakReference: Boolean = false ): void  {
			this._eventDispatcher.addEventListener( type, listener, useCapture, priority, useWeakReference );
		}
		public function dispatchEvent(event:Event):Boolean {
			return this._eventDispatcher.dispatchEvent(event);
		}
		public function hasEventListener( type: String ): Boolean {
			return this._eventDispatcher.hasEventListener( type );
		}
		public function removeEventListener( type: String, listener: Function, useCapture: Boolean = false ): void {
			this._eventDispatcher.removeEventListener( type, listener, useCapture );
		}
		public function willTrigger( type: String ): Boolean {
			return this._eventDispatcher.willTrigger( type );
		}

	}
	
}