package net.saqoosha.garapon {

	import away3d.core.proto.Object3D;
	
	import flash.events.Event;
	import flash.utils.getTimer;
	
	
	/**
	 * ObjectAnimatorとか言って、実際はCameraだけしか対応していない罠。
	 * いちおうカメラアニメーションするとこまでは作ったんだけど、結局使っていない。
	 * たぶんそのうちPV3Dの中の人が似たようなものを作ってくれるはず。
	 */
	public class ObjectAnimator {
		
		private var _dataXml:XML;
		private var _obj:Object3D;
		private var _animation:Object;
		private var _startTime:Number;
		private var _currentTime:Number;

		public function ObjectAnimator(data:XML, obj:Object3D) {
			this._dataXml = data;
			this._obj = obj;
			this._animation = new Object();
			this.parseCollada();
			this._startTime = 0;
			this._currentTime = 0;
			this._update(null);
		}
		
		public function start(time:Number = 0):void {
			this._startTime = getTimer() - time;
			StageRef.getInstance().addEventListener(Event.ENTER_FRAME, this._update);
		}
		
		public function stop():void {
			StageRef.getInstance().removeEventListener(Event.ENTER_FRAME, this._update);
		}
		
		private function parseCollada():void {
			default xml namespace = this._dataXml.namespace();
			
			var cattr:XMLList = this._dataXml.library_cameras.camera[0]..perspective;

			var animes:XMLList = this._dataXml.library_animations.animation;
			var samplers:XMLList = this._dataXml.library_animations..sampler;
			var sources:XMLList = this._dataXml.library_animations..source;

			var smpl:XMLList;
			var src:XMLList;
			var input:Object;
			var output:Object;
			var tmp:Array;
			var a:Number;

			for each (var anime:XML in animes) {
				var tgt:Array = anime.channel.@target.match(/^Camera\/(.+)/);
				if (tgt != null) {
					smpl = samplers.(@id == String(anime.channel.@source).split('#')[1]);
					src = smpl.input.(@semantic == 'INPUT');
					input = this.sourceToObject(sources.(@id == String(src.@source).split('#')[1]));
					src = smpl.input.(@semantic == 'OUTPUT');
					output = this.sourceToObject(sources.(@id == String(src.@source).split('#')[1]));
					switch (tgt[1]) {
						case 'translate':
							this._animation.x = new ValueInterpolator(input.TIME, output.X, 100);
							this._animation.y = new ValueInterpolator(input.TIME, output.Z, 100);
							this._animation.z = new ValueInterpolator(input.TIME, output.Y, 100);
							break;
							
						case 'rotateX.ANGLE':
							tmp = new Array();
							for each (a  in output.ANGLE) {
								tmp.push(a - 90);
							}
							this._animation.rotationX = new ValueInterpolator(input.TIME, tmp);
							//cam.rotationX =  val.ANGLE[0] - 90;
							break;
							
						case 'rotateY.ANGLE':
							this._animation.rotationZ = new ValueInterpolator(input.TIME, output.ANGLE);
							//cam.rotationZ = val.ANGLE[0];
							break;
							
						case 'rotateZ.ANGLE':
							tmp = new Array();
							for each (a in output.ANGLE) {
								tmp.push(-a);
							}
							this._animation.rotationY = new ValueInterpolator(input.TIME, tmp);
							//cam.rotationY = -val.ANGLE[0];
							break;
					}
				}
			}
		}
		
		private function sourceToObject(data:XMLList):Object {
			var ret:Object = new Object();
			var keys:Array = new Array();
			for each (var p:String in data.technique_common.accessor.param.@name) {
				keys.push(p);
				ret[p] = new Array();
			}
			var vals:Array = String(data.float_array).split(' ');
			var count:Number = Number(data.technique_common.accessor.@count);
			var stride:Number = Number(data.technique_common.accessor.@stride);
			for (var i:Number = 0; i<count; i++) {
				for (var j:Number = 0; j<stride; j++) {
					ret[keys[j]].push(vals.shift());
				}
			}
			return ret;
		}
		
		public function _update(e:Event):void {
			this._currentTime = getTimer() - this._startTime;
			for (var prop:String in this._animation) {
				var v:* = ValueInterpolator(this._animation[prop]).getValue(this._currentTime / 1000);
				this._obj[prop] = v;
			}
			//this._obj.x = this._animation['x'].getValue(this._currentTime / 1000);
		}
		
		public function set time(t:Number):void {
			this._startTime = getTimer() - t;
			this._update(null);
		}
		
		public function get time():Number {
			return this._currentTime;
		}
	}
}