package net.saqoosha.garapon {

	import flash.display.Stage;
	import flash.utils.Proxy;
	import flash.utils.flash_proxy;
	
	
	/**
	 * DisplayObjectのサブクラス以外のクラスからもStageクラスにアクセスできるように作ってみました。
	 * ProxyつかってStageにあるプロパティ／メソッドすべてにアクセスできるようにしてある。
	 * ただーし、コードヒントがでないのでそこだけはちょっと使いづらい。
	 */
	public dynamic class StageRef extends Proxy {
		
		private static var _stage:Stage;
		private static var _inst:StageRef;
		
		/**
		 * とりあえずアプリケーションの最初のどっかでgetInstanceするまえにStageのインスタンスを設定しとく。
		 * @param stage	Stageクラスのインスタンス。
		 */
		public static function init(stage:Stage):void {
			_stage = stage;
			_inst = new StageRef();
		}
		
		/**
		 * StageRefクラスのインスタンスを返す。
		 * @return 
		 * 
		 */
		public static function getInstance():StageRef {
			return _inst
		}
		
		/**
		 * Proxy関連。サンプルコピペ。
		 */		
		override  flash_proxy function callProperty(methodName:*, ... args):* {
			return _stage[methodName].apply(_stage, args);
		}
		override flash_proxy function getProperty(name:*):* {
			return _stage[name];
		}
		override flash_proxy function setProperty(name:*, value:*):void {
			_stage[name] = value;
		}
		
	}
}